var LevelMenu = {
	run: function() {
		var x = GetScreenWidth() * 0.5 - 30;
		var y = GetScreenHeight() / 2;
		
		var mm = new Menu(x, y, 90, 600);
		mm.addDefaultKeys(KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT, Keys.ACCEPT, Keys.CANCEL);
		mm.setWindowStyle(WINDOW);
		mm.setArrow(ARROWMENU);
		mm.addText("Easy", function() {
			PlayPrologue(0);
			EatKey();
		}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
		mm.addText("Medium", function() {
			PlayPrologue(1);
			EatKey();
		}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
		mm.addText("Hard", function() {
			PlayPrologue(2);
			EatKey();
		}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
		mm.addText("Intense", function() {
			PlayPrologue(3);
			EatKey();
		}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
		mm.addText("Back", function() {
			mm.escape_function();
		}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
		mm.preRender = function() {
			BACKGROUND.blit(0, 0);
			LOGO.blit(95, 40);
			this.defaultPreRender();
		}
		mm.escapeable = function(){ return true; }
		
		mm.execute();
	}
};

function PlayPrologue(difficultyBoost) {
	Score = 0;
	EatKey();
	Message("Once upon a time, the world was enveloped in a great darkness. When there seemed to be no respite, when there seemed to be no more hope, a hero appeared.");
	Message("He banished the darkness and returned the light. The clouds cleared, the grass turned green, happiness was restored. But the hero was gone. Nobody saw him, and nobody knew his name...");
	PlayLevelOne(difficultyBoost);
}

function PlayLevelOne(difficultyBoost) {
	EatKey();
	
	Message("Earl: You there! You're my partner, right?", EARLNEUTRAL);
	Message("Earl: Are you sure you're up for this tournament? You look a little green.", EARLSKEPTICAL);
	Message("Earl: Whatever, you can deal with it. Hey, there's our first opponents!", EARLNEUTRAL);
	Message("Ripper: You goan down, lil pipsqueeks! I goan kill you both!", RIPPERANGRY);
	Message("Girder: Grawwrrwr! Goan rip you to shreds!", GIRDERANGRY);
	Message("Earl: You look greener... Well, don't worry. We'll beat 'em easy!", EARLAMUSED);
	
	var cont= false;
	var tmpScore = Score;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(750 - difficultyBoost*200, 4 - difficultyBoost, RIPPERANGRY, RIPPERBEATEN, RIPPERHAPPY, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Girder: Grrwaww-w-what? What happened?", GIRDERSAD);
			Message("Ripper: We l-lost?! Papa goan tear our heads off!", RIPPERBEATEN);
			Message("Earl: Wasn't too bad, right?", EARLAMUSED);
			PlayLevelTwo(difficultyBoost);
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				EatKey();
				Message("Ripper: Gwahahaha! Trash will always lose!", RIPPERHAPPY);
				Message("Girder: Gwohoho! It's only natural, after all.", GIRDERHAPPY);
				Message("Earl: Sorry, partner. Maybe next year.", EARLSKEPTICAL);
				if(IsNewHighscore()) {
					Message("Earl: Hey... do you perhaps remember your name?", EARLSERIOUS);
					var name = GetName();
					Message("Earl: Ah, " + name + ", huh? Eh. I guess that's an okay name.", EARLNEUTRAL);
					AddToHighscores(name);
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}

function PlayLevelTwo(difficultyBoost) {
	EatKey();
	
	Message("Earl: Let's see here. Our next opponent is...", EARLNEUTRAL);
	Message("Rose: H-hello?", ROSENEUTRAL);
	Message("Earl: Where's your partner?", EARLNEUTRAL);
	Message("Rose: I'm a dainty girl! Don't go hittin on me now!", ROSEFLIRTING);
	Message("Earl: Uh. What?", EARLSKEPTICAL);
	Message("Rose: Oh, how BEAUTACIOUS! Come, let's battle. Please don't break a fingernail!", ROSEFLIRTING);
	
	var cont = false;
	var tmpScore = Score;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(725 - difficultyBoost*200, 4 - difficultyBoost, ROSENEUTRAL, ROSEANGRY, ROSEFLIRTING, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Rose: I can't believe it! You broke not one but all my fingernails!", ROSEANGRY);
			Message("Earl: She left crying... Serves her right for acting like a stereotypical woman.", EARLAMUSED);
			Message("Earl: Well, partner, we've done two battles now, but I never learned your name.", EARLNEUTRAL);
			Message("Earl: Huh? Are you saying you're a mute?", EARLSKEPTICAL);
			Message("Earl: What? Not only that, but also an amnesiac?", EARLSERIOUS);
			Message("Earl: I'm sorry, man. Let's get our minds off this, what do you say?", EARLSKEPTICAL);
			PlayLevelThree(difficultyBoost);
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				EatKey();
				Message("Rose: Your skills are no match for my beauty!", ROSEFLIRTING);
				Message("Earl: We lost to a dame? Bad luck there. Maybe next time, eh?", EARLSKEPTICAL);
				if(IsNewHighscore()) {
					Message("Earl: Hey... do you perhaps remember your name?", EARLSERIOUS);
					var name = GetName();
					Message("Earl: Ah, " + name + ", huh? Eh. I guess that's an okay name.", EARLNEUTRAL);
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}

function PlayLevelThree(difficultyBoost) {
	EatKey();
	
	Message("Earl: Right then. Our next opponent is--", EARLNEUTRAL);
	Message("Pascal: SHAZAM! It is I, Pascal! Beware my magical prowess!", PASCALNEUTRAL);
	Message("Earl: Wait a minute. Where is your partn--", EARLSKEPTICAL);
	Message("Pascal: It is surely providence that we meet on opposite sides of the battlefield! It must be your fate... to lose! Come, let us battle!", PASCALHAPPY);
	
	var tmpScore = Score;
	var cont = false;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(700 - difficultyBoost*200, 4 - difficultyBoost, PASCALNEUTRAL, PASCALANGRY, PASCALHAPPY, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Earl: He left. Laughing to himself, no less.", EARLNEUTRAL);
			Message("Earl: But that's aside the point. We have some things to discuss.", EARLSERIOUS);
			Message("Earl: You need a partner to drop the pieces or push them into lines, right?", EARLSKEPTICAL);
			Message("Earl: But these guys do it all on their own.", EARLSERIOUS);
			Message("Earl: There's something strange going on here...", EARLSERIOUS);
			Message("Earl: Nothing we can do but go on, though. We'll find the truth, I promise.", EARLSERIOUS);
			PlayLevelFour(difficultyBoost);
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				EatKey();
				Message("Earl: We... lost?", EARLSKEPTICAL);
				Message("Pascal: There's no escaping fate!", PASCALHAPPY);
				Message("Earl: Well, maybe next time.", EARLSKEPTICAL);
				if(IsNewHighscore()) {
					Message("Earl: Hey... do you perhaps remember your name?", EARLSERIOUS);
					var name = GetName();
					Message("Earl: Ah, " + name + ", huh? Eh. I guess that's an okay name.", EARLNEUTRAL);
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}

function PlayLevelFour(difficultyBoost) {
	EatKey();
	
	Message("Earl: Our next opponent... is Jess.", EARLNEUTRAL);
	Message("Earl: How about that. No interruption!", EARLAMUSED);
	Message("Earl: Ack! There he is!", EARLSKEPTICAL);
	Message("Jess: Pitiful. Your meaningless existence will soon end, knights.", JESSNEUTRAL);
	Message("Earl: What an evil aura... What are you?", EARLSERIOUS);
	Message("Jess: Don't concern yourself with trivialities, knaves. Let us battle, knuckle to knuckle.", JESSNEUTRAL);
	
	var cont = false;
	var tmpScore = Score;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(625 - difficultyBoost*200, 3.5 - difficultyBoost, JESSNEUTRAL, JESSHURT, JESSHAPPY, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Jess: I've been beaten... but you'll never beat my brother, knuckleheads.", JESSNEUTRAL);
			Message("Earl: Kn... knuckleheads? Are you running out of 'kn' words?", EARLSERIOUS);
			Message("Jess: ...", JESSNEUTRAL);
			Message("Earl: He ran away. Wait. How did he say that ellipsis out loud?", EARLSKEPTICAL);
			PlayLevelFive(difficultyBoost);
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				EatKey();
				Message("Jess: ...", JESSNEUTRAL);
				Message("Earl: This guy is good... We'll get him next time.", EARLSERIOUS);
				if(IsNewHighscore()) {
					Message("Earl: Hey... do you perhaps remember your name?", EARLSERIOUS);
					var name = GetName();
					Message("Earl: Ah, " + name + ", huh? Eh. I guess that's an okay name.", EARLNEUTRAL);
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}

function PlayLevelFive(difficultyBoost) {
	EatKey();
	
	Message("Earl: Well, anyway. The tournament's almost done. We should be one battle before the semi-finals right now.", EARLNEUTRAL);
	Message("Earl: All right. Next opponent--", EARLSERIOUS);
	Message("Creazy: Hey, you! Creazy saw you from before. From that time, righto?", CREAZYNEUTRAL);
	Message("Earl: Huh? You talking to me?", EARLSKEPTICAL);
	Message("Creazy: Ain't talkin to you, white boxley! Talkin to other boxley over there.", CREAZYNEUTRAL);
	Message("Earl: What... what do you mean?", EARLSERIOUS);
	Message("Creazy: Creazy gonna eat you now. Creazy a-hungry!", CREAZYHAPPY);
	
	var cont = false;
	var tmpScore = Score;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(600 - difficultyBoost*200, 3 - difficultyBoost, CREAZYNEUTRAL, CREAZYHURT, CREAZYHAPPY, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Creazy: Creazy beaten? Creazy sad... but Creazy a-hungry... CREAZY A-HUNGRY!!", CREAZYHURT);
			Message("Earl: Whoa! He's foaming at the mouth! Watch out!", EARLSKEPTICAL);
			Message("Earl: ... He collapsed. And he's drooling...", EARLSERIOUS);
			Message("Earl: Let's move on to the next round.", EARLNEUTRAL);
			PlayLevelSix(difficultyBoost);
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				EatKey();
				Message("Creazy: Creazy won! Now Creazy gonna eatchu! Creazy a-hungry!");
				Message("Earl: Urk! Run! Otherwise there won't be a next year!", EARLSERIOUS);
				if(IsNewHighscore()) {
					Message("Earl: And while I'm at it! Do you perhaps remember your name?", EARLSERIOUS);
					var name = GetName();
					Message("Earl: Ah, " + name + ", huh? Eh. I guess that's an okay name.", EARLNEUTRAL);
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}

function PlayLevelSix(difficultyBoost) {
	EatKey();
	
	Message("Earl: The semi-finals! Aren't you excited?", EARLNEUTRAL);
	Message("Earl: Let's see--Urk!", EARLSKEPTICAL);
	Message("Earl: Who's that guy? What a scary aura...", EARLSERIOUS);
	Message("Earl: And where's his partner?", EARLSKEPTICAL);
	Message("???: ... Name's Black. As for my partner... I have no need for one.", BLACKNEUTRAL);
	Message("Black: ... I remember you... You're from that time. The hero with no name.", BLACKNEUTRAL);
	Message("Earl: The hero with no name? Oh, you mean that fairy tale?", EARLSKEPTICAL);
	Message("Black: ... You'll pay... for beating my little brother...", BLACKNEUTRAL);
	
	var cont = false;
	var tmpScore = Score;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(550 - difficultyBoost*200, 2.5 - difficultyBoost, BLACKNEUTRAL, BLACKHURT, BLACKHAPPY, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Black: ...", BLACKHURT);
			Message("Earl: He fled. Well, partner, I'm curious about you now. People seem to think you're the hero from the fairy tale.", EARLSKEPTICAL);
			Message("Earl: You think so, too? I can't believe it myself. It's a bit too superstitious for me.", EARLNEUTRAL);
			Message("Earl: Come on, let's go to the next finals.", EARLAMUSED);
			PlayLevelSeven(difficultyBoost);
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				Message("Black: ...", BLACKNEUTRAL);
				Message("Earl: What incredible power... We have to train some more. We'll beat him next year.", EARLSERIOUS);
				if(IsNewHighscore()) {
					Message("Earl: Hey... do you perhaps remember your name?", EARLSERIOUS);
					var name = GetName();
					Message("Earl: Ah, " + name + ", huh? That's a good name.", EARLNEUTRAL);
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}

function PlayLevelSeven(difficultyBoost) {
	EatKey();
	
	Message("Earl: The finals... We've fought so hard for so long, and now we're finally here!", EARLNEUTRAL);
	Message("Earl: We'll find the truth, partner. I promised you, and I won't break my word.", EARLNEUTRAL);
	Message("Earl: Hey, over there. That guy, is he our next opponent?", EARLNEUTRAL);
	Message("???: Well, well... It's been a long time.", DUSKNEUTRAL);
	Message("Earl: I've never seen you before in my life.", EARLSKEPTICAL);
	Message("???: Of course you wouldn't. But I believe your friend there would know me. I'm Dusk, your next opponent.", DUSKNEUTRAL);
	Message("Dusk: Personally, I'm surprised you beat all my subordinates--", DUSKNEUTRAL);
	Message("Ripper: You goan die! Where's Girder?! Where's Ripper's partner?!", RIPPERANGRY);
	Message("Earl: What--What are you talking about?", EARLSERIOUS);
	Message("Ripper: Goan rip Dusk to shreds! For Girder!", RIPPERANGRY);
	Message("Dusk: Tch. Get out of my face.", DUSKNEUTRAL);
	Message("Ripper: Urgh... so... strong!", RIPPERBEATEN);
	Message("Earl: A-amazing... How did you gain so much power?", EARLSERIOUS);
	Message("Dusk: Heh. If you manage to defeat me, I'll tell you.", DUSKNEUTRAL);
	Message("Ripper: Ripper miss Girder... Ripper miss him! Where is he? Tell Ripper!", RIPPERBEATEN);
	Message("Dusk: As if I'd tell such a thing to swine.", DUSKNEUTRAL);
	Message("Ripper: White boxley beat Dusk for me? Please?", RIPPERBEATEN);
	Message("Earl: ... I'll do it. Dusk, I'll defeat you. In Ripper and Girder's name.", EARLSERIOUS);
	Message("Dusk: Very well. But I must warn you. I have become far more powerful than I have ever been!", DUSKHAPPY);
	
	var cont = false;
	var tmpScore = Score;
	do {
		cont = false;
		EatKey();
		CurrentBoard = new BrickBoard(500 - difficultyBoost*200, 2 - difficultyBoost, DUSKNEUTRAL, DUSKHURT, DUSKHAPPY, Create2DArray(12, 22));
		if(CurrentBoard.play()) {
			Message("Dusk: I-Impossible... I can't be beaten...", DUSKHURT);
			Message("Earl: So, you were just telling us the secret to your power?", EARLNEUTRAL);
			Message("Dusk: Imbeciles... Very well. I'll keep my promise.", DUSKHURT);
			Message("Dusk: Have you ever looked into my eye? It has the power to absorb life energies.", DUSKNEUTRAL);
			Message("Earl: No... that can't be.", EARLSERIOUS);
			Message("Dusk: Ha ha ha ha! That's right, little boxleys! Girder, along with all the other contestants, no longer exists in this world!", DUSKHAPPY);
			Message("Dusk: I have absorbed their energies! They're all a part of me!", DUSKHAPPY);
			Message("Ripper: NO! RIPPER GOAN KILL YOU!", RIPPERBEATEN);
			Message("Dusk: Begone!", DUSKHAPPY);
			Message("Earl: Wh-whoa! An earthquake!", EARLSKEPTICAL);
			Pause(500);
			Message("Earl: Wow... what an explosion!", EARLSKEPTICAL);
			Message("Earl: Look! Ripper and Dusk... they're gone!", EARLNEUTRAL);
			Message("Earl: Ripper must have saved the world... he saved us all. I never thought he'd have it in him.", EARLNEUTRAL);
			Message("Earl: Hmm? What's that you're telling me? You've got your memory back?", EARLNEUTRAL);
			Message("Earl: Really? All of it? Well... May I ask a question?", EARLNEUTRAL);
			Message("Earl: Now that you've got your memory back... could you tell me your name?", EARLNEUTRAL);
			var name = GetName();
			Message("Earl: Really? " + name + "... It's a beautiful name.", EARLNEUTRAL);
			
			Message("And so the darkness was banished once again, this time never to return.");
			Message("Their task done, the two boxes waddled down the road into the sunset.");
			Message("The world never forgot the heroes' names: Earl, Ripper, and " + name + "...");
			//add to scoreboard
			AddToHighscores(name);
			EatKey();
			Highscores.run();
			EatKey();
		} else if(!CurrentBoard.forceExit) {
			cont = ContinueMenu();
			if(!cont) {
				Message("Dusk: Ha ha ha ha! So much for you insects and the hero without a name!", EARLNEUTRAL);
				Message("Earl: I can't believe it... We lost.", EARLSERIOUS);
				Message("And so the world was enveloped in a darkness that never ceased. All light and hope was lost, never to return.");
				Message("The world never found out the hero's name:");
				if(IsNewHighscore()) {
					AddToHighscores(GetName());
					EatKey();
					Highscores.run();
					EatKey();
				}
			} else if(difficultyBoost != 3) {
				Score = 0;
			} else {
				Score = tmpScore;
			}
		}
	} while(cont == true);
}